/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth;

import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.config.BonsaiConfigException;
import com.ibm.hwmca.ui.bonsai.config.NavAreaConfigBean;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.TaskManager;
import com.ibm.hwmca.ui.bonsai.earth.event.RemoveTreePropertyEvent;
import com.ibm.hwmca.ui.bonsai.earth.event.ReplaceTreePropertyEvent;
import com.ibm.hwmca.ui.bonsai.earth.event.StatusTreePropertyEvent;
import com.ibm.hwmca.ui.bonsai.earth.event.TreePropertyListener;
import com.ibm.hwmca.ui.bonsai.earth.event.UIInfoTreePropertyEvent;
import com.ibm.hwmca.ui.bonsai.earth.util.BonsaiRegurgitater;
import com.ibm.hwmca.ui.bonsai.earth.util.TreeBuildFailedException;
import com.ibm.hwmca.ui.bonsai.event.EventQueue;
import com.ibm.hwmca.ui.bonsai.servlet.util.UserObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BonsaiTreeManager {
    private static final String TRACEMASK_T = "XBUIMGRT";
    private static final String TRACEMASK_F = "XBUIMGRF";
    private static final String TRACEMASK_D = "XBUIMGRD";
    private static final Object LOCK = new Object();
    private static BonsaiTreeManager treeManager;
    private static NavAreaConfigBean configBean;
    private List rootNodes;
    private Map idToNodeMap;
    private EventQueue eventQueue;
    private Set treeListeners;

    private BonsaiTreeManager(NavAreaConfigBean bean) throws BonsaiConfigException {
        Trace.trace(TRACEMASK_T, "<> BonsaiTreeManager(" + bean + ")");
        boolean initialized = false;
        while (!initialized) {
            try {
                this.rootNodes = BonsaiRegurgitater.getTrees(bean.getTrees(), bean.getNodes(), null);
                Iterator i = this.rootNodes.iterator();
                while (i.hasNext()) {
                    ((BonsaiTreeNode)i.next()).prepareForActivation();
                }
                initialized = true;
            }
            catch (RuntimeException rtEx) {
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException iEx) {}
            }
        }
        this.idToNodeMap = new HashMap();
        this.registerNodeIds(this.rootNodes);
        this.eventQueue = new EventQueue("BTM.EventQueue");
        this.treeListeners = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(NavAreaConfigBean bean) throws BonsaiConfigException {
        Trace.trace(TRACEMASK_T, "<--> BonsaiTreeManager.init(" + bean + ")");
        Object object = LOCK;
        synchronized (object) {
            if (TaskManager.getTaskManager() == null) {
                throw new IllegalStateException("The TaskManager must be initialized before this manager can be!");
            }
            if (treeManager == null) {
                configBean = bean;
                treeManager = new BonsaiTreeManager(bean);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BonsaiTreeManager getBonsaiTreeManager() {
        Object object = LOCK;
        synchronized (object) {
            return treeManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getRootNodes() {
        Object object = LOCK;
        synchronized (object) {
            return this.rootNodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BonsaiTreeNode getTreeNode(String id) {
        Object object = LOCK;
        synchronized (object) {
            return (BonsaiTreeNode)this.idToNodeMap.get(id);
        }
    }

    public List getTreeNodes(List ids) {
        ArrayList<BonsaiTreeNode> nodes = new ArrayList<BonsaiTreeNode>(ids.size());
        BonsaiTreeNode node = null;
        Iterator i = ids.iterator();
        while (i.hasNext()) {
            node = this.getTreeNode((String)i.next());
            if (node == null) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public List getTreeNodesByTreePath(String[] treePath) {
        return this.findNodesByTreePath(this.rootNodes, treePath, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTableProperties(String id, UserObject userObj) {
        Object object = LOCK;
        synchronized (object) {
            BonsaiTreeNode parent = this.getTreeNode(id);
            if (parent == null) {
                return null;
            }
            ArrayList<Map> properties = new ArrayList<Map>();
            BonsaiTreeNode child = null;
            Iterator i = parent.getChildren().iterator();
            while (i.hasNext()) {
                child = (BonsaiTreeNode)i.next();
                if (!child.isShown(userObj, false)) continue;
                properties.add(child.getTableProperties(userObj));
            }
            return properties;
        }
    }

    public EventQueue getEventQueue() {
        return this.eventQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTreePropertyListener(TreePropertyListener listener) {
        Set set = this.treeListeners;
        synchronized (set) {
            this.treeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getTreePropertyListeners() {
        Set set = this.treeListeners;
        synchronized (set) {
            return new HashSet(this.treeListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTreePropertyListener(TreePropertyListener listener) {
        Set set = this.treeListeners;
        synchronized (set) {
            this.treeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rebuildBranch(BonsaiTreeNode node) {
        Trace.trace(TRACEMASK_T, "-> BonsaiTreeManager.rebuildBranch(" + node + ")");
        BonsaiTreeNode copy = null;
        Object object = LOCK;
        synchronized (object) {
            BonsaiTreeNode parent = node.getParent();
            copy = node.getCopy(parent, false);
            try {
                copy.addChildren(BonsaiRegurgitater.getTrees(copy.getConfigBean().getChildren(), configBean.getNodes(), copy));
            }
            catch (BonsaiConfigException bcEx) {
                throw new TreeBuildFailedException("Runtime configuration exception! (" + bcEx.toString() + ")");
            }
            node.prepareForReplacement(copy);
            if (parent == null) {
                this.rootNodes.set(this.rootNodes.indexOf(node), copy);
            } else {
                parent.replaceChild(node.getId(), copy);
            }
            this.deregisterNodeIds(node);
            this.registerNodeIds(copy);
        }
        this.eventQueue.enqueue(new ReplaceTreePropertyEvent(node, copy, this.getTreePropertyListeners()));
        Trace.trace(TRACEMASK_T, "<- BonsaiTreeManager.rebuildBranch()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBranch(BonsaiTreeNode node) {
        Trace.trace(TRACEMASK_T, "-> BonsaiTreeManager.removeBranch(" + node + ")");
        Object object = LOCK;
        synchronized (object) {
            node.prepareForRemoval();
            BonsaiTreeNode parent = node.getParent();
            if (parent == null) {
                this.rootNodes.remove(node);
            } else {
                parent.removeChild(node.getId());
            }
            this.deregisterNodeIds(node);
        }
        this.eventQueue.enqueue(new RemoveTreePropertyEvent(node, this.getTreePropertyListeners()));
        Trace.trace(TRACEMASK_T, "<- BonsaiTreeManager.removeBranch()");
    }

    void statusChange(BonsaiTreeNode node) {
        Trace.trace(TRACEMASK_T, "-> BonsaiTreeManager.statusChange(" + node + ")");
        this.eventQueue.enqueue(new StatusTreePropertyEvent(node, this.getTreePropertyListeners()));
        Trace.trace(TRACEMASK_T, "<- BonsaiTreeManager.statusChange()");
    }

    void uiinfoChange(BonsaiTreeNode node) {
        Trace.trace(TRACEMASK_T, "-> BonsaiTreeManager.uiinfoChange(" + node + ")");
        this.eventQueue.enqueue(new UIInfoTreePropertyEvent(node, this.getTreePropertyListeners()));
        Trace.trace(TRACEMASK_T, "<- BonsaiTreeManager.uiinfoChange()");
    }

    private void registerNodeIds(BonsaiTreeNode node) {
        this.idToNodeMap.put(node.getId(), node);
        this.registerNodeIds(node.getChildren());
    }

    private void registerNodeIds(List nodes) {
        BonsaiTreeNode node = null;
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            node = (BonsaiTreeNode)i.next();
            this.idToNodeMap.put(node.getId(), node);
            this.registerNodeIds(node.getChildren());
        }
    }

    private void deregisterNodeIds(BonsaiTreeNode node) {
        this.idToNodeMap.remove(node.getId());
        this.deregisterNodeIds(node.getChildren());
    }

    private void deregisterNodeIds(List nodes) {
        BonsaiTreeNode node = null;
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            node = (BonsaiTreeNode)i.next();
            this.idToNodeMap.remove(node.getId());
            this.deregisterNodeIds(node.getChildren());
        }
    }

    private List findNodesByTreePath(List nodes, String[] treePath, int level) {
        boolean lastRecursion = level == treePath.length - 1;
        ArrayList<BonsaiTreeNode> matches = new ArrayList<BonsaiTreeNode>();
        BonsaiTreeNode node = null;
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            node = (BonsaiTreeNode)i.next();
            if (!node.getXMLKey().equals(treePath[level])) continue;
            if (lastRecursion) {
                matches.add(node);
                continue;
            }
            matches.addAll(this.findNodesByTreePath(node.getChildren(), treePath, level + 1));
        }
        return matches;
    }
}

